﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{


    [DataObjectAttribute()]
    public static class QuotationsDetailsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static QuotationsDetails GetItem(Guid QuotationsDetailsID, Guid QuotationsID, string keyword)
        {
            return QuotationsDetailsDB.GetItem(QuotationsDetailsID, QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<QuotationsDetails> GetList(Guid QuotationsDetailsID, Guid QuotationsID, string keyword)
        {
            return QuotationsDetailsDB.GetList(QuotationsDetailsID, QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid QuotationsDetailsID, Guid QuotationsID, string keyword)
        {
            return QuotationsDetailsDB.GetDataTable(QuotationsDetailsID, QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid QuotationsDetailsID, Guid QuotationsID, string keyword)
        {
            return QuotationsDetailsDB.GetDataSet(QuotationsDetailsID, QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(QuotationsDetails myQuotationsDetails)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                QuotationsDetailsDB.Save(myQuotationsDetails);
                myTransactionScope.Complete();
                return true;
            }
        }
        
    }
}
